<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'feedback' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbmail_feedback_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	$headings[] = $vbphrase['edit'];
	if (VBMAIL::$isPro) $headings[] = $vbphrase['delete'];
	
	
	if (count(VBMAIL::$cache['feedback']))
	{
		print_form_header('vbmail', 'feedback');
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_vbmail_feedback_management'], count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach (VBMAIL::$cache['feedback'] as $feedbackid => $feedback)
		{
			// Table data
			$cell = array();
			$cell[] = $feedback['title'];
			$cell[] = $feedback['description'];
			$cell[] = ($feedback['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$feedbackid]\" value=\"$feedback[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			$cell[] = construct_link_code($vbphrase['edit'], 'vbmail.php?' . $vbulletin->session->vars['sessionurl'] . 'do=feedback&amp;action=modify&amp;feedbackid=' . $feedbackid);
			/*DBTECH_PRO_START*/ $cell[] = construct_link_code($vbphrase['delete'], 'vbmail.php?' . $vbulletin->session->vars['sessionurl'] . 'do=feedback&amp;action=delete&amp;feedbackid=' . $feedbackid);/*DBTECH_PRO_END*/
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		
		if (VBMAIL::$isPro) print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"feedback\" value=\"" . str_pad($vbphrase['dbtech_vbmail_add_new_feedback'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbmail.php?do=feedback&amp;action=modify'\" />");
		else print_table_footer();	
	}
	else
	{
		if (!VBMAIL::$isPro) print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_feedback'], 0);
		
		print_form_header('vbmail', 'feedback');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbmail_feedback_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbmail_no_feedbacks'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbmail_add_new_feedback'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$feedbackid = $vbulletin->input->clean_gpc('r', 'feedbackid', TYPE_UINT);
	$feedback = ($feedbackid ? VBMAIL::$cache['feedback'][$feedbackid] : false);
	
	if (!is_array($feedback))
	{
		// Non-existing feedback
		$feedbackid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Uninteresting',
		'description' 	=> 'The emails from this mailing list are uninteresting.',
		'displayorder' 	=> 10,
		'active' 		=> 1,
	);
	
	if ($feedbackid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbmail_editing_x_y'], $vbphrase['dbtech_vbmail_feedback'], $feedback['title'])));
		print_form_header('vbmail', 'feedback');
		construct_hidden_code('action', 'update');
		construct_hidden_code('feedbackid', $feedbackid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbmail_editing_x_y'], $vbphrase['dbtech_vbmail_feedback'], $feedback['title']));

		$vbphrase['dbtech_vbmail_title']  		= $vbphrase['title'] 		. construct_phrase($vbphrase['dbtech_vbmail_title_translation'], 		$feedback['feedbackid']);
		$vbphrase['dbtech_vbmail_description']  = $vbphrase['description'] 	. construct_phrase($vbphrase['dbtech_vbmail_description_translation'], 	$feedback['feedbackid']);
	}
	else
	{
		if (!VBMAIL::$isPro) print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_feedback'], 0);
		
		// Add
		print_cp_header($vbphrase['dbtech_vbmail_add_new_feedback']);
		print_form_header('vbmail', 'feedback');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbmail_add_new_feedback']);
		
		$feedback = $defaults;

		$vbphrase['dbtech_vbmail_title']  		= $vbphrase['title'];
		$vbphrase['dbtech_vbmail_description']  = $vbphrase['description'];
	}
	
	print_description_row($vbphrase['dbtech_vbmail_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['dbtech_vbmail_title'], 			'feedback[title]', 			$feedback['title']);	
	print_textarea_row($vbphrase['dbtech_vbmail_description'],	'feedback[description]',	$feedback['description']);
	print_input_row($vbphrase['display_order'], 				'feedback[displayorder]', 	$feedback['displayorder']);
	print_yes_no_row($vbphrase['active'],						'feedback[active]',			$feedback['active']);
	print_submit_row(($feedbackid ? $vbphrase['save'] : $vbphrase['dbtech_vbmail_add_new_feedback']), $vbphrase['reset'], count($headings));	
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'feedbackid' 	=> TYPE_UINT,
		'feedback' 	=> TYPE_ARRAY,
	));

	// init data manager
	$dm =& VBMAIL::initDataManager('Feedback', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['feedbackid'])
	{
		if (!$existing = VBMAIL::$cache['feedback'][$vbulletin->GPC['feedbackid']])
		{
			// Couldn't find the feedback
			print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_feedback'], $vbulletin->GPC['feedbackid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = $vbphrase['dbtech_vbmail_edited'];
	}
	else
	{
		if (!VBMAIL::$isPro) print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_feedback'], 0);
		
		// Added
		$phrase = $vbphrase['dbtech_vbmail_added'];
	}
	
	// feedback fields
	foreach ($vbulletin->GPC['feedback'] AS $key => $val)
	{
		if (!$vbulletin->GPC['feedbackid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
	
	define('CP_REDIRECT', 'vbmail.php?do=feedback');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['dbtech_vbmail_feedback'], $phrase);	
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $feedbackid => $displayorder)
		{
			if (!$existing = VBMAIL::$cache['feedback'][$feedbackid])
			{
				// Couldn't find the feedback
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBMAIL::initDatamanager('Feedback', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbmail.php?do=feedback');
	print_stop_message('saved_display_order_successfully');	
}

/*DBTECH_PRO_START*/
// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'feedbackid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbmail_delete_x'], $vbphrase['dbtech_vbmail_feedback']));
	print_delete_confirmation('dbtech_vbmail_feedback', $vbulletin->GPC['feedbackid'], 'vbmail', 'feedback', 'dbtech_vbmail_feedback', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'feedbackid' 	=> TYPE_UINT,
		'kill' 		=> TYPE_BOOL
	));
	
	if (!$existing = VBMAIL::$cache['feedback'][$vbulletin->GPC['feedbackid']])
	{
		// Couldn't find the feedback
		print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_feedback'], $vbulletin->GPC['feedbackid']);
	}
	
	// init data manager
	$dm =& VBMAIL::initDataManager('Feedback', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbmail.php?do=feedback');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['dbtech_vbmail_feedback'], $vbphrase['dbtech_vbmail_deleted']);	
}
/*DBTECH_PRO_END*/

print_cp_footer();